/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.collections.shorts;

/**
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public abstract class AbstractShortCollection implements ShortCollection {

    public int size() {                                                       
        short size = 0;                                                        
        for (ShortIterator itr = iterator(); itr.hasNext();) size++;           
        return size;                                                          
    }                                                                         
                                                                              
    public boolean isEmpty() {
        return size() == 0;
    }

    public boolean contains(short e) {
        for (ShortIterator itr = iterator(); itr.hasNext();) {
            if (itr.next() == e) return true;
        }
        return false;
    }

    public abstract ShortIterator iterator();

    public short[] toArray() {
        short[] a = new short[size()];
        int i=0;
        for (ShortIterator itr = iterator(); itr.hasNext();) {
            a[i++] = itr.next();
        }

        return a;
    }

    public short[] toArray(short[] a) {
        int size = size();
        if (a.length < size) a = new short[size];
        int i=0;
        for (ShortIterator itr = iterator(); itr.hasNext();) {
            a[i++] = itr.next();
        }

        return a;
    }

    public boolean add(short e) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(short e) {
        for (ShortIterator itr = iterator(); itr.hasNext();) {
            if (itr.next() == e) {
                itr.remove();
                return true;
            }
        }
        return false;
    }

    public boolean containsAll(ShortCollection c) {
        for (ShortIterator itr = c.iterator(); itr.hasNext();) {
            if (!contains(itr.next())) return false;
        }
        return true;
    }

    public boolean addAll(ShortCollection c) {
        boolean modified = false;
        for (ShortIterator itr = c.iterator(); itr.hasNext();) {
            modified |= add(itr.next());
        }
        return modified;
    }

    public boolean retainAll(ShortCollection c) {
        boolean modified = false;
        for (ShortIterator itr = iterator(); itr.hasNext();) {
            if (!c.contains(itr.next())) {
                itr.remove();
                modified = true;
            }
        }
        return modified;
    }

    public boolean removeAll(ShortCollection c) {
        boolean modified = false;

        if (c == this) {
            modified = !isEmpty();
            clear();
            return modified;
        }

        for (ShortIterator itr = iterator(); itr.hasNext();) {
            if (c.contains(itr.next())) {
                itr.remove();
                modified = true;
            }
        }
        return modified;
    }

    public void clear() {
        for (ShortIterator itr = iterator(); itr.hasNext();) {
            itr.next();
            itr.remove();
        }
    }

    public String toString() {
        ShortIterator itr = iterator();
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        while (itr.hasNext()) {
            buf.append(itr.next());
            if (itr.hasNext()) buf.append(',');
        }
        buf.append(']');
        return buf.toString();
    }
}
